/*
 * Dynamic_Calibration.h
 *
 *  	Created on: Jan 26, 2013
 *      Author: Alexander Kozitsky
 */

#ifndef DYNAMIC_CALIBRATION_H_
#define DYNAMIC_CALIBRATION_H_
#include "types.h"

#define MOVING_WINDOW_WHERE_MAXIMUM_SAMPLE_IS_COMPENSATED_FOR	60
// DELAY_LINE_NUMBER_OF_SAMPLES keeps track of up to this many maximum values, safe size is 1/2 of MOVING_WINDOW_WHERE_MAXIMUM_SAMPLE_IS_COMPENSATED_FOR, (possible go as low a 1/5)
// risk with too low values is that with certain change sample patterns critical time samples may be pushed out of the buffer and lost prematurely
// bare minimum is 2-3 times THRESHOLD_OFFSET
#define NUMBER_OF_MAXIMUM_VALUES_TO_TRACK 						30
#define DELAY_LINE_NUMBER_OF_SAMPLES							15		// number of samples in the delay line (delay time is period times this value)
																		// the delay line causes a delay in the samples coming into the system
																		// this is needed since when a user presents a tag, the delay line is flushed
																		// to the oldest value to prevent negatively influencing the calibration algorithm
																		// so the delay time is the maximum time that a user would take to present the card
																		// into the field and produce a read
#define IGNORE_SAMPLES_AFTER_READ								9		// ignore this many samples after read, this allows the user to remove the card
																		// without corrupting the calibration algorithm with high values
																		// This also has the effect of preventing a re-read this many samples after the initial one


extern u16_t SniffCardTimeThreshold;

u08_t Automatic_Calibration(u16_t time, u16_t threshold_offset);
u16_t Next_Value_In_Delay_Buffer(u16_t last_value);
void Set_All_Values_In_Delay_Buffer_To (u16_t value);
u16_t Store_Value_In_Min_Buffer (u16_t time);
void Fill_Delay_Buffer_With_Oldest_Value ();

#endif /* DYNAMIC_CALIBRATION_H_ */
